/*------------------------------------------------------------------------------*
 * File Name: Curve.h															*
 * Creation: TD 4-14-03															*
 * Purpose: Origin C header file for Origin basic Data types					*
 * Copyright (c) OriginLab Corp.	2002 - 2007									*
 * All Rights Reserved															*
 * Modifications:																*
 *	ML 8/9/2007 QA70-10169 OC_INITIALIZING_CURVE_FROM_XYRANGE					*
 *	ML 8/20/2007 QA70-10261 OC_INITIALIZING_CURVE_FOR_OUTPUT_XYRANGE			*
 *	ML 8/27/2007 SETTING_LOWER_UPPER_INDEX_FOR_X_OF_CURVE						*
 *	ML 12/23/2008 CURVE_CONSTRUCTORS_FROM_XYRANGE_AND_DATAPLOT_WITH_TEMP_SERIES	*
 *	ML 2/26/2009 QA70-13169 RESAMPLE_DESTINATION_CURVE_SHOULD_OPTIONALLY_TAKE_i1_FROM_SOURCE
 *	Folger 10/31/09 QA81-14526 REMOVE_CURVE_SORT_TO_MAKE_CONSISTENT_WITH_CURVEBASE_SORT
 *------------------------------------------------------------------------------*/

#ifndef _CURVE_H
#define _CURVE_H
#define _CURVE_BASE

#include <vector.h>

// The following are related to sorting
#define		NS_DESCENDING			0x2000
#define		NS_MISSING_AS_SMALLEST	0x1000 // If this bit is on missing values are treated as the smallest value when sorting...otherwise they are treated as the as the largest value

// Comments last updated by Joseph on 08/07/2007
/**+
http://ocwiki.originlab.com/index.php?title=Category:curvebase_(class)
*/
class curvebase : public vectorbase
{
	// Comments last updated by LAS on 03/05/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-GetName
	*/
	BOOL	GetName(string& strName); //Get the name of an internal Origin dataset.

	// Comments last updated by LAS on 03/05/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-GetName
	*/
	string  GetName();  //Get the name of an internal Origin dataset.

	// Comments last updated by LAS on 03/05/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-IsValid
	*/
	BOOL	IsValid();  //Checks the validity of an Origin C Dataset object.
	
	// Comments last updated by LAS on 03/16/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-Update
	*/
	void	Update(BOOL bFromOrigin, int mode = -1); // Update an Origin C Curve object from an Origin data set or vice-versa. 

// Comments last updated by LAS on 03/17/2005
#ifdef _POST_ORIGIN7_
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-Append
	*/
	BOOL	Append(vectorbase& v, int iMode);
#else
// Comments last updated by Format on 06/05/2008
	/**
			Append data from a vector or Dataset object to this Origin C Dataset
			object and update the Origin dataset from this Origin C Dataset object.
		Keywords:
			Append;curvebase,Append; Vector,Append
		Example1:
			//Can test with either a worksheet of data or a graph window with at least one plot
			int curvebase_Append_ex1(int npts)
			{
				PageBase pbTemp;
				pbTemp = Project.Pages(); // Get the project's active page
				Curve aa,bb;
				vector a(npts);
				vector b(npts);
				static int nn = 1;
				switch( pbTemp.GetType() )
				{
					case EXIST_WKS:
						Worksheet wks(Project.ActiveLayer());			
						aa.Attach(wks,0);
						bb.Attach(wks,1);
						break;
					case EXIST_PLOT:  
						GraphLayer	gl = Project.ActiveLayer(); // Get active layer in project file
						if(gl)                                  // If valid graph layer...
						{
							DataPlot dp = gl.DataPlots(0);      // Get first data plot in graph layer
							if(dp)                              // If valid DataPlot...
							{
								Curve crv(dp);                  // Get Curve from DataPlot
								string dsXName;
								crv.HasX(dsXName);
								aa.Attach(dsXName);
								bb.Attach(dp.GetDatasetName());
							}
						}                    
						break;
					default:
						printf("Active window is not worksheet or graph.");
				}
				for(int ii = 0; ii < npts; ii++)
				{
					a[ii] = nn++;
					b[ii] = rnd();
				}
				aa.Append(a, REDRAW_REALTIME);
				bb.Append(b, REDRAW_REALTIME);
				return 0;
			}
		Parameters:
			v = [input] vector or Dataset to append
			iMode = [input] Dataset update mode, allowed values are
					REDRAW_NONE				do update
					REDRAW_REALTIME			graph realtime drawing, only the new added data will be drawn		
					REDRAW_REALTIME_WKS		similar to REDRAW_REALTIME_SCOPE, but redraw the entire worksheet	
					REDRAW_REFRESH			do a simple refresh of the data
					REDRAW_REALTIME_SCOPE	this is used to do realtime drawing for the entire range of data. To see effect in plots, must set dataplots to animate mode
		Return:
			Returns TRUE on successful exit and FALSE on failure.
		SeeAlso:
			vectorbase::Append, curvebase::Update
	*/
	BOOL	Append(vector& v, int iMode = REDRAW_NONE); // Append data from a vector or Dataset object to this Origin C Dataset object.
#endif //!_POST_ORIGIN7_

// Comments last updated by Format on 06/05/2008
 	/**+
_	http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-TrimLeft
 	*/
 	int		TrimLeft(BOOL bShiftLeft = FALSE); // TrimLeft removes elements having the value NANUM from the left end of a Dataset.

// Comments last updated by Format on 06/05/2008
 	/**+
_	http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-TrimRight
 	*/
 	int		TrimRight(BOOL bDelExtra = FALSE); // TrimRight removes elements having the value NANUM from the right end of a Dataset.

// Comments last updated by LAS on 03/18/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-Sort
	*/
	BOOL	Sort(DWORD dwFlags = 0); // Use a Curve object to sort a Y data set according to an X data set.

// Comments last updated by Format on 06/05/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-HasX
	*/
	BOOL HasX(string& strXdatasetName = NULL); // Checks whether or not this Curve object has an associated X data set.

// Comments last updated by LAS on 03/30/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-AttachX
	*/
	BOOL AttachX(Dataset& dsX, BOOL SetXRangeToYRange = TRUE); // Attach an Origin C Dataset object to the X data set associated with this Curve object.
	
// Comments last updated by Format on 06/05/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-SetUpperBound
	*/
	BOOL 	SetUpperBound(int nUpper); // Set the upper display index of the Dataset.

// Comments last updated by Format on 06/05/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-SetLowerBound
	*/
	BOOL 	SetLowerBound(int nLower); // Set the lower display index of the Dataset.

	/// ML 8/27/2007 SETTING_LOWER_UPPER_INDEX_FOR_X_OF_CURVE
	/**$
		Sets lower and/or upper bounds of the X data.
	Parameters:
		nLower = [input] the lower bound value to set. -1 to leave it as is.
		nUpper = [input] the upper bound value to set. -1 to leave it as is.
	Returns: 
		TRUE if success, othewise FALSE.
	*/
	BOOL	SetXBounds(int nLower, int nUpper);
	/// end SETTING_LOWER_UPPER_INDEX_FOR_X_OF_CURVE

	
// Comments last updated by LAS on 04/01/2005	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-GetRectPoints
*/
	int GetRectPoints( fpoint& fptTopLeft, fpoint& fptBottomRight, vector<double>& vX, vector<double>& vY, vector<int>& vIndex ); // Find all the points in a Curve which fall on or within a specified rectangle.

// Comments last updated by LAS on 04/01/2005
// DSC 4/21/05 We will not document this function, so I added $	
	/**$
 		Example1:
	 		int curvebase_GetSourceRange_ex1(string dsName = "Book1_B")
			{
				Curve crv(dsName);
				int nLow, nUp;
				crv.SetLowerBound(1);
				crv.SetUpperBound(8);
				bool bOK = crv.GetSourceRange(nLow, nUp);
				if(!bOK)
				{
					printf("The range of Book1_b is %d,%d\n", nLow+1, nUp+1);
					return 0;
				}
				else
					return 1;
			}
			// Assuming Book1_A(X) and Book1_B(Y) exist with the following data:
			// Book1_B={1,2,3,4,5,6,7,8,9,10}
			// Book1_A={1,2,3,4,5,6,7,8,9,10};	
			//The output is the following:
				//The range of Book1_b is 2,9
				//RUN_GETSOURCERANGE()=0
		Parameters:
			nLower = [output] Get the lower bound of the curve
			nUpper = [output] Get the upper bound of the curve
		Return:
			Returns FALSE on success.
	*/
	bool	GetSourceRange(int &nLower, int &nUpper);
	
	//Commments last updated by Joseph 08/08/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-CopyX
	*/
	bool	CopyX(curvebase &cbSource);
	
	//Commments last updated by Joseph 08/08/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:curvebase-CopyData
	*/
	bool	CopyData(vector& vx, vector& vy, vector& yWeight = NULL, vector& xWeight = NULL);

};


















/**+
http://ocwiki.originlab.com/index.php?title=Category:Curve_(class)
*/
class Curve : public curvebase
{
public:

//Comments last updated by LAS on 4/4/05	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Curve
	*/
	Curve(); // Default constructor for Curve class.

//Comments last updated by LAS on 4/4/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Curve
	*/
	Curve(Curve crvOriginal); // Copy constructor for Curve class.

//Comments last updated by LAS on 4/4/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Curve
	*/
	Curve(LPCSTR lpcszYData); // Construct a Curve from a Y data set name and an associated X data set.

//Comments last updated by LAS on 4/4/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Curve
	*/
	Curve(LPCSTR lpcszXData, LPCSTR lpcszYData); // Construct a Curve from X and Y data set names.

//Comments last updated by LAS on 4/4/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Curve
	*/
	Curve(Dataset dsX, Dataset dsY); // Construct a Curve from X and Y Datasets.

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Curve
	*/
	/// ML 2/26/2009 QA70-13169 RESAMPLE_DESTINATION_CURVE_SHOULD_OPTIONALLY_TAKE_i1_FROM_SOURCE
	//Curve(Curve &cvSrc, Curve &cvResample, BOOL bCommonRangeIntersect = TRUE); // Construct an Overlapping curve
	Curve(Curve &cvSrc, Curve &cvResample, BOOL bCommonRangeIntersect = TRUE, BOOL bi1FromSource = FALSE); // Construct an Overlapping curve
	/// end RESAMPLE_DESTINATION_CURVE_SHOULD_OPTIONALLY_TAKE_i1_FROM_SOURCE

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Curve
	*/
	Curve(Worksheet & wks, int nColX, int nColY); // Construct a Curve from a Worksheet and X and Y column numbers.

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Curve
	*/
	Curve(Worksheet & wks, int nColY); // Construct a Curve from a Worksheet, a Y column number, and an associated X column.

//Comments last updated by LAS on 4/8/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Curve
	*/
	Curve(DataPlot& dp); // Construct a Curve from a DataPlot

	/// ML 12/23/2008 CURVE_CONSTRUCTORS_FROM_XYRANGE_AND_DATAPLOT_WITH_TEMP_SERIES
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Curve
	*/
	Curve(DataPlot& dp, BOOL bTemp);
	/// end CURVE_CONSTRUCTORS_FROM_XYRANGE_AND_DATAPLOT_WITH_TEMP_SERIES

	
	// Comments last updated by DSC on 04/21/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Curve
	*/
	Curve(curvebase &cv, int &nNumMissingInCopy, int &nSrcOffset, DWORD dwOptions = 0, int nLower = -1, int nUpper = -1);// create a copy of data, all doubles, handle missing values

	/// ML 8/9/2007 QA70-10169 OC_INITIALIZING_CURVE_FROM_XYRANGE
	/**$
			Constructor for Curve class. The X and Y dataasets come from the supplied XYRange object. It can be used for XYRange's
			that are inputs of xfunctions.
	*/
	Curve(XYRange &xy);
	/// end OC_INITIALIZING_CURVE_FROM_XYRANGE

	/// ML 12/23/2008 CURVE_CONSTRUCTORS_FROM_XYRANGE_AND_DATAPLOT_WITH_TEMP_SERIES
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Curve
	*/
	Curve(DWORD dwUnused, XYRange &xy);
	/// end CURVE_CONSTRUCTORS_FROM_XYRANGE_AND_DATAPLOT_WITH_TEMP_SERIES


	/// ML 8/20/2007 QA70-10261 OC_INITIALIZING_CURVE_FOR_OUTPUT_XYRANGE
	/**$
			Constructor for Curve class. It creates temporary datasets for Y and X and attaches them to the object.
			In the destructor it writes into the data referred to by xy. It should be used with XYRange's that are
			output arguments of xfunctions.
		Parameters:
			xy = [input] the XYRange to write to by the curve.
			bNoX = [input] if TRUE, the destructor will not write into X, but only into Y
			bNoDataRemoval = [input] When FALSE (default) the curve destructor will resize the column to the size of the range even if that means it will lead to shrink the column size..
	*/
	Curve(XYRange &xy, BOOL bNoX, BOOL bNoDataRemoval = FALSE);
	/// end OC_INITIALIZING_CURVE_FOR_OUTPUT_XYRANGE

	/**$
	
		Construct an Overlapping curve.
	Parameters:
		cvSrc = [input]The curve created is a replica of this input curve
		cvResample = [input] use to resample the created curve
		bCommonRangeIntersect = [input] when TRUE the temporay curve is defined only over the intersection of
								X-ranges of the two curves, otherwise a union is used.
	Remark:
		Construct/Reconstructs the object with temporary datasets after destroying the existing object. 
		The cvSrc and cvResample forces creation of a temporary curve that represents cvSrc data on 
		a resampled set to accomodate domain of cvResample.
	*/
	ConstructInit(Curve &cvSrc, Curve &cvResample, BOOL bCommonRangeIntersect = TRUE); // Construct an Overlapping curve


//Comments last updated by LAS on 4/8/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Attach
	*/
	BOOL	Attach(LPCSTR lpcszYData); // Attach an Origin C Curve object to an internal Origin Y data set and its associated X data set.

//Comments last updated by LAS on 4/8/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Attach
	*/
	BOOL	Attach(LPCSTR lpcszXData, LPCSTR lpcszYData); // Attach an Origin C Curve object to internal Origin X and Y data sets.

//Comments last updated by LAS on 4/8/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Detach
	*/
	BOOL	Detach(); // Detach an Origin C Curve object from internal Origin data sets.
	
//Comments last updated by LAS on 4/8/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Attach
	*/
	BOOL	Attach(Worksheet & wks, int nColX, int nColY);  // Attach an Origin C Curve object to internal Origin X and Y data sets.
	
//Comments last updated by LAS on 4/8/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Attach
	*/
	BOOL	Attach(Worksheet & wks, int nColY);  //Attach an Origin C Curve object to internal Origin X and Y datasets.

//Comments last updated by Format on 06/05/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Attach
	*/
	BOOL	Attach(LPCSTR lpcszWksName, int nCol); // Attach a Dataset object to a worksheet column identified by worksheet name and column number.

//Comments last updated by Format on 06/05/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Attach
	*/
	BOOL	Attach(Column & col); // Attach a Dataset object to a worksheet column identified by a Column object.

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Create
	*/
	BOOL	Create(int Size, UINT Option = 0); // Create an internal Origin data set (may or may not be temporary).

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Destroy
	*/
	void 	Destroy(); // Detach the Origin C Dataset object and Destroy (delete) the internal Origin data set.


#if  _OC_VER > 0x0703
	///------ Folger 10/31/09 QA81-14526 REMOVE_CURVE_SORT_TO_MAKE_CONSISTENT_WITH_CURVEBASE_SORT
	///**+
	//http://ocwiki.originlab.com/index.php?title=OriginC:Curve-Sort
	//*/
	//BOOL Sort(BOOL wOption = SORT_ASCENDING);
	///------ End REMOVE_CURVE_SORT_TO_MAKE_CONSISTENT_WITH_CURVEBASE_SORT

	
	/**$	
	*/
	BOOL	PushUndo(int i1 = 0, int i2 = -1);
#endif // _OC_VER > 0x0703
};

#endif//_CURVE_H
